#ifndef LINKED_LIST_H_INCLUDED
#define LINKED_LIST_H_INCLUDED


struct NamedRef
{
  char*     pParent;
  char*     pChild;
  NamedRef* pNext;
  NamedRef();
  NamedRef(const char* parent, const char* child, NamedRef* next);
  ~NamedRef();
};

typedef NamedRef* lpNamedRef;
extern lpNamedRef g_pHList;


void AddFirst(lpNamedRef& head, const char* ParName, const char* ChldName);
void AddLast (lpNamedRef& head, const char* ParName, const char* ChldName);
void DeleteList( lpNamedRef& head);
void DeleteFirst(lpNamedRef& head);
void DeleteLast( lpNamedRef& head);
void DeleteNode( lpNamedRef& head, const char* ParName, const char* ChldName);
void DeleteRef(  lpNamedRef& head, lpNamedRef ref);
void MoveChildren(  lpNamedRef head, const char* fromParent, const char* toParent);
void MoveNode(  lpNamedRef head, const char* nodeName, const char* toParent);
bool FindRef(lpNamedRef head, lpNamedRef pRef);
bool FindRef(lpNamedRef head, const char* ParName, const char* ChldName, lpNamedRef* ppRes);
bool FindParent(lpNamedRef head, const char* ChildName, lpNamedRef* ppRes);
bool FindNextChild(lpNamedRef head, const char* ParName, const char* currChild, lpNamedRef* ppRes);
bool HasChild(lpNamedRef head, const char* ParName);
long CountChilds(lpNamedRef node);
long CountChilds(lpNamedRef head, const char* parName);
long CountAllChilds(lpNamedRef node);
long CountAllChilds(lpNamedRef head, const char* parName);
bool IsDirectChild(lpNamedRef head, const char* ChildName, const char* ParName);
bool IsIndirectChild(lpNamedRef head, const char* ChildName, const char* ParName);
//----------------------------------------------------------------
// Tool functions. (implemented in Tools.cpp
bool ValidateList(char* &pszErrorBuf);
long RequiredChunkSize();
long Save(CFile* pFile);
long Load(CFile* pFile);

#endif
